************************ Set working directory and personal ado file directory

*for example
cd "C\IDS\DTA files"
discard
sysdir set PERSONAL "C\IDS\Extended IDS software"
clear


************************ Import DemoDatabase
capture program drop ImportDemoDatabase
program define ImportDemoDatabase

*IDS tables
import excel "DemoDatabase.xlsx", sheet("INDIVIDUAL") firstrow clear
destring _all, replace
save INDIVIDUAL.dta, replace

import excel "DemoDatabase.xlsx", sheet("CONTEXT") firstrow clear
destring _all, replace
save CONTEXT.dta, replace

import excel "DemoDatabase.xlsx", sheet("INDIV_CONTEXT") firstrow clear
destring _all, replace
save INDIV_CONTEXT.dta, replace

import excel "DemoDatabase.xlsx", sheet("CONTEXT_CONTEXT") firstrow clear
destring _all, replace
save CONTEXT_CONTEXT.dta, replace

import excel "DemoDatabase.xlsx", sheet("INDIV_INDIV") firstrow clear
destring _all, replace
save INDIV_INDIV.dta, replace

import excel "DemoDatabase.xlsx", sheet("METADATA") firstrow clear
save METADATA.dta, replace

*EIDS tables
import excel "DemoDatabase.xlsx", sheet("INDIVIDUAL_EXT") firstrow clear
destring _all, replace
tostring Value ,replace
replace Value = "" if Value=="."
save INDI_EXT_import.dta, replace

import excel "DemoDatabase.xlsx", sheet("CONTEXT_EXT") firstrow clear
destring _all, replace
save CONT_EXT_import.dta, replace

*Metadata for extended variables
import excel "DemoDatabase.xlsx", sheet("IND_MET_Import") firstrow clear
save IND_MET_Import.dta, replace

import excel "DemoDatabase.xlsx", sheet("CON_MET_Import") firstrow clear
save CON_MET_Import.dta, replace

*Value labels
import excel "DemoDatabase.xlsx", sheet("Labels") firstrow clear
save labels.dta, replace

end



************************ Run programs

/* Help files
help IDSextended
help importData
help householdSize
help selectType
help appendIndivVar
help appendContextVar
help EpisodesFileCreator
*/


**** Dataset for a mortality study
ImportDemoDatabase

capture log close
log using "RunPrograms.log", replace

IDSextended , chronicle(1) varSetup(1) individual(1) context(1)

importData INDI_EXT_import IND_MET_Import INDIVIDUAL_EXT 
importData CONT_EXT_import.dta CON_MET_Import CONTEXT_EXT 

householdSize

selectType, contextExt(1) individualExt(1) individual(1)
/*Open the created Excel files
INDIVIDUAL_SELECT
INDIVIDUAL_EXT_SELECT
CONTEXT_EXT_SELECT

Insert the value 1 in the column select for the desired variables. 
Set Duration to Continuous or instant

For example: 
 - 	select Birth_date, Birth_location, Death and Sex from the INDIVIDUAL_SELECT 
	table, set the field Duration to Instant in Death and Continuous in the 
	other two variables 
 -	select At_risk_mortality from the INDIVIDUAL_EXT_SELECT file, set the field Duration 
	to Continuous  
 - 	select all variables from CONTEXT_EXT_SELECT file, set Duration to Instant for 
	Head_occupation and Continuous for the other two variables

Save and close each Excel file after selecting variables.
*/

appendIndivVar , table(INDIVIDUAL)
appendIndivVar , table(INDIVIDUAL_EXT)
appendContextVar, table(CONTEXT_EXT)

EpisodesFileCreator using labels.dta, atrisk(At_risk_mortality)


log close




**** Dataset for a fertility study
ImportDemoDatabase

IDSextended , chronicle(1) varSetup(1) individual(1) context(1)

importData INDI_EXT_import IND_MET_Import INDIVIDUAL_EXT 
importData CONT_EXT_import.dta CON_MET_Import CONTEXT_EXT 

householdSize

selectType, contextExt(1) individualExt(1) individual(1)
/*Open the created Excel files
INDIVIDUAL_SELECT
INDIVIDUAL_EXT_SELECT
CONTEXT_EXT_SELECT

Insert the value 1 in the column select for the desired variables. 
Set Duration to Continuous or instant

Include at least At_risk_fertility and Child_birth from INDIVIDUAL_EXT_SELECT

Save and close each Excel file after selecting variables
*/

appendIndivVar , table(INDIVIDUAL)
appendIndivVar , table(INDIVIDUAL_EXT)

appendContextVar, table(CONTEXT_EXT)

EpisodesFileCreator using labels.dta, atrisk(At_risk_fertility)



/* Erase files used

*Erase imported files
erase labels.dta
erase CON_MET_Import.dta
erase IND_MET_Import.dta
erase METADATA.dta
erase CONT_EXT_import.dta
erase INDI_EXT_import.dta
erase INDIV_INDIV.dta
erase CONTEXT_CONTEXT.dta
erase INDIVIDUAL.dta
erase CONTEXT.dta
erase INDIV_CONTEXT.dta

*Erase files created by the programs
erase CONTEXT_EXT.dta
erase INDIVIDUAL_EXT.dta
erase CONTEXT_EXT_SELECT.xls
erase INDIVIDUAL_EXT_SELECT.xls
erase INDIVIDUAL_SELECT.xls
erase Chronicle.dta
erase VarSetup.dta






